#
# Makefile for FPSE/Amiga
#

CC = pgcc -V 2.95.2 -warpup
LD = pgcc -V 2.95.2 -warpup
RM = rm -f

DIR_INCLUDE = include
DIR_MICROPR = cpu/ppc
DIR_OSYSTEM = system/amiga
DIR_LIBRARY = system/amiga/plugin
DIR_OBJECTS = obj

DEFS     = -DMSB_FIRST
INCLUDE  = -I$(DIR_INCLUDE) -I$(DIR_OSYSTEM)
DEBUG    = -Wall
OPTIMIZE = -O3 -fomit-frame-pointer

CFLAGS   = $(DEFS) $(INCLUDE) $(DEBUG) $(OPTIMIZE)

OBJNAMES = cpu2.o mem.o emu.o hw.o bios.o win.o \
compile.o runtime.o gte.o malloc.o cdrom.o dis.o \
sio.o mdec.o idctfst.o debug.o rs232.o joypad.o \
setup.o init.o \

LIBNAMES = cd.a joy.a spu.a gpu.a

OBJS = $(addprefix $(DIR_OBJECTS)/, $(OBJNAMES))
LIBS = $(addprefix $(DIR_LIBRARY)/, $(LIBNAMES))

all:fpse.exe

$(DIR_OBJECTS)/compile.o: $(DIR_MICROPR)/compile.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/rs232.o:   $(DIR_OSYSTEM)/rs232.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/init.o:    $(DIR_OSYSTEM)/init.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/setup.o:   $(DIR_OSYSTEM)/setup.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/win.o:     $(DIR_OSYSTEM)/win.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

$(DIR_OBJECTS)/%.o: %.c
	$(CC) $(DEFS) $(CFLAGS) -c -o $@ $<

fpse.exe: $(OBJS)
	$(LD) $(CFLAGS) -o fpse.exe $(OBJS) $(LIBS)
	elf2exe2 fpse.exe fpse.exe

dis.exe: dis.c
	$(CC) $(CFLAGS) dis.c -o dis.exe -DMAKEDIS

clean :
	$(RM) *.exe
	$(RM) $(DIR_OBJECTS)/*.o
